/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.zapper;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class ZapperDescriptor
extends DeviceDescriptor {
    public static final int Trigger = 0;
    public static final int OffscreenReload = 1;
    public static final int RewindTime = 2;
    private static final Component.Identifier.Button[] DEFAULTS = new Component.Identifier.Button[]{Component.Identifier.Button.LEFT, Component.Identifier.Button.MIDDLE, Component.Identifier.Button.RIGHT};

    public ZapperDescriptor() {
        super(4);
    }

    @Override
    public String getDeviceName() {
        return "Zapper";
    }

    @Override
    public int getButtonCount() {
        return 3;
    }

    @Override
    public int getRewindTimeButton() {
        return 2;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Trigger";
            }
            case 1: {
                return "Offscreen Reload";
            }
            case 2: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultMouse(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.updateRewindTime(pressedValues[2] != 0, portIndex);
        int mouseCoordinates = InputUtil.getMouseCoordinates();
        int buttons = 0;
        if (mouseCoordinates != 65535) {
            if (pressedValues[0] != 0) {
                buttons = 4;
            } else if (pressedValues[1] != 0) {
                buttons = 4;
                mouseCoordinates = 65535;
            }
        }
        return bits | mouseCoordinates << 16 | (portIndex == 0 ? buttons : buttons << 8);
    }
}

