/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.bandai;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Bandai74161_7432
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean controlledMirroring;

    public Bandai74161_7432(CartFile cartFile, boolean controlledMirroring) {
        super(cartFile, 4, 1);
        this.controlledMirroring = controlledMirroring;
    }

    @Override
    public void init() {
        this.setPrgBank(2, 0);
        this.setPrgBank(3, -1);
        this.setChrBank(0);
        this.setNametableMirroring(0);
    }

    @Override
    public void writeRegister(int address, int value) {
        boolean mirroring = BitUtil.getBitBool(value, 7);
        if (mirroring) {
            this.controlledMirroring = true;
        }
        if (this.controlledMirroring) {
            this.setNametableMirroring(mirroring ? 3 : 2);
        }
        this.setPrgBank(2, value >> 4 & 7);
        this.setChrBank(value & 0xF);
    }
}

