/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.bandai;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class FCG
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected static final int X24C0X_STANDBY = 0;
    protected static final int X24C0X_ADDRESS = 1;
    protected static final int X24C0X_WORD = 2;
    protected static final int X24C0X_READ = 3;
    protected static final int X24C0X_WRITE = 4;
    protected int[] x24c0x_data = new int[256];
    protected int x24c0x_state = 0;
    protected int x24c0x_addr;
    protected int x24c0x_word;
    protected int x24c0x_latch;
    protected int x24c0x_bitcount;
    protected int x24c0x_sda;
    protected int x24c0x_scl;
    protected int x24c0x_out;
    protected int x24c0x_oe;
    protected int x24c02;
    protected boolean irqCounting;
    protected int irqCounter;
    protected int irqLatch;

    public FCG(CartFile cartFile) {
        super(cartFile, 4, 8, 24576, 32768);
        this.setPrgBank(3, -1);
    }

    @Override
    public int readMemory(int address) {
        if (!this.nonVolatilePrgRamPresent && (address & 0xE000) == 24576) {
            return this.x24c0x_read();
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF) {
            case 8: {
                this.setPrgBank(2, value & 0xF);
                break;
            }
            case 9: {
                this.setNametableMirroring(value & 3);
                break;
            }
            case 10: {
                this.writeIrqControl(value);
                break;
            }
            case 11: {
                this.writeIrqCounterLow(value);
                break;
            }
            case 12: {
                this.writeIrqCounterHigh(value);
                break;
            }
            case 13: {
                this.x24c0x_write(value);
            }
        }
    }

    protected void writeIrqControl(int value) {
        this.irqCounting = BitUtil.getBitBool(value, 0);
        this.irqCounter = this.irqLatch;
        this.cpu.setMapperIrq(false);
    }

    protected void writeIrqCounterHigh(int value) {
        this.irqLatch = this.irqLatch & 0xFF | value << 8;
    }

    protected void writeIrqCounterLow(int value) {
        this.irqLatch = this.irqLatch & 0xFF00 | value;
    }

    @Override
    public void update() {
        if (this.irqCounting) {
            this.irqCounter = this.irqCounter - 1 & 0xFFFF;
            if (this.irqCounter == 0) {
                this.cpu.setMapperIrq(true);
            }
        }
    }

    protected void x24c0x_write(int data) {
        int sda = data >> 6 & 1;
        int scl = data >> 5 & 1;
        this.x24c0x_oe = data >> 7;
        if (this.x24c0x_scl != 0 && scl != 0) {
            if (this.x24c0x_sda != 0 && sda == 0) {
                this.x24c0x_state = 1;
                this.x24c0x_bitcount = 0;
                this.x24c0x_addr = 0;
            } else if (this.x24c0x_sda == 0 && sda != 0) {
                this.x24c0x_state = 0;
            }
        } else if (this.x24c0x_scl == 0 && scl != 0) {
            switch (this.x24c0x_state) {
                case 1: {
                    if (this.x24c0x_bitcount < 7) {
                        this.x24c0x_addr <<= 1;
                        this.x24c0x_addr |= sda;
                    } else {
                        if (this.x24c02 == 0) {
                            this.x24c0x_word = this.x24c0x_addr;
                        }
                        this.x24c0x_state = sda != 0 ? 3 : (this.x24c02 != 0 ? 2 : 4);
                    }
                    ++this.x24c0x_bitcount;
                    break;
                }
                case 2: {
                    if (this.x24c0x_bitcount == 8) {
                        this.x24c0x_word = 0;
                        this.x24c0x_out = 0;
                    } else {
                        this.x24c0x_word <<= 1;
                        this.x24c0x_word |= sda;
                        if (this.x24c0x_bitcount == 16) {
                            this.x24c0x_bitcount = 7;
                            this.x24c0x_state = 4;
                        }
                    }
                    ++this.x24c0x_bitcount;
                    break;
                }
                case 3: {
                    if (this.x24c0x_bitcount == 8) {
                        this.x24c0x_out = 0;
                        this.x24c0x_latch = this.x24c0x_data[this.x24c0x_word];
                        this.x24c0x_bitcount = 0;
                        break;
                    }
                    this.x24c0x_out = this.x24c0x_latch >> 7;
                    this.x24c0x_latch <<= 1;
                    ++this.x24c0x_bitcount;
                    if (this.x24c0x_bitcount != 8) break;
                    ++this.x24c0x_word;
                    this.x24c0x_word &= 0xFF;
                    break;
                }
                case 4: {
                    if (this.x24c0x_bitcount == 8) {
                        this.x24c0x_out = 0;
                        this.x24c0x_latch = 0;
                        this.x24c0x_bitcount = 0;
                        break;
                    }
                    this.x24c0x_latch <<= 1;
                    this.x24c0x_latch |= sda;
                    ++this.x24c0x_bitcount;
                    if (this.x24c0x_bitcount != 8) break;
                    this.x24c0x_data[this.x24c0x_word] = this.x24c0x_latch;
                    ++this.x24c0x_word;
                    this.x24c0x_word &= 0xFF;
                }
            }
        }
        this.x24c0x_sda = sda;
        this.x24c0x_scl = scl;
    }

    protected int x24c0x_read() {
        return this.x24c0x_out << 4;
    }
}

