/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.bandai;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class OekaKidsTablet
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int outer;
    private int inner;

    public OekaKidsTablet(CartFile cartFile) {
        super(cartFile, 2, 2);
        this.xram = new int[32768];
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.xram[this.chrBanks[address >> 12] | address & 0xFFF];
        }
        return this.vram[address];
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192) {
            this.xram[this.chrBanks[address >> 12] | address & 0xFFF] = value;
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.outer = value & 4;
        this.setPrgBank(1, value & 3);
        this.setChrBank(1, this.outer | 3);
        this.updateChrBank0();
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        if ((address & 0x3000) == 8192 && (address & 0x3FF) < 960) {
            this.inner = address >> 8 & 3;
            this.updateChrBank0();
        }
    }

    private void updateChrBank0() {
        this.setChrBank(0, this.outer | this.inner);
    }
}

