/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.bitcorp;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper357
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[][] BANKS = new int[][]{{4, 3, 5, 3, 6, 3, 7, 3}, {1, 1, 5, 1, 4, 1, 5, 1}};
    private int dips;
    private int irqCounter;
    private int bankSMB2J;
    private int bankUNROM;
    private boolean irqEnabled;
    private boolean bankSwap;

    public Mapper357(CartFile cartFile) {
        super(cartFile, 8, 1, 16384, 24576);
    }

    @Override
    public void init() {
        this.bankSMB2J = 3;
        this.irqCounter = 0;
        this.irqEnabled = false;
        this.bankSwap = false;
        this.updateState();
    }

    @Override
    public void resetting() {
        this.dips = this.dips + 8 & 0x18;
        this.init();
    }

    private void updateState() {
        if (this.dips == 0) {
            if (this.bankSwap) {
                this.setPrgBank(3, 0);
                this.setPrgBank(4, 0);
                this.setPrgBank(5, 0);
                this.setPrgBank(6, BANKS[1][this.bankSMB2J]);
                this.setPrgBank(7, 8);
            } else {
                this.setPrgBank(3, 2);
                this.setPrgBank(4, 1);
                this.setPrgBank(5, 0);
                this.setPrgBank(6, BANKS[0][this.bankSMB2J]);
                this.setPrgBank(7, 10);
            }
        } else {
            this.set2PrgBanks(4, (this.dips | this.bankUNROM) << 1);
            this.set2PrgBanks(6, (this.dips | 7) << 1);
        }
        this.setNametableMirroring(this.dips == 24 ? 1 : 0);
    }

    @Override
    public void update() {
        if (this.irqEnabled && (++this.irqCounter & 0xFFF) == 0) {
            this.cpu.setMapperIrq(true);
        }
    }

    @Override
    public void writeRegister(int address, int value) {
        if (address >= 32768) {
            this.bankUNROM = value & 7;
            this.updateState();
        }
        switch (address & 0x71FF) {
            case 16418: {
                this.bankSMB2J = value & 7;
                this.updateState();
                break;
            }
            case 16672: {
                this.bankSwap = (value & 1) != 0;
                this.updateState();
            }
        }
        if ((address & 0xF1FF) == 16674) {
            this.irqEnabled = (value & 1) != 0;
            this.irqCounter = 0;
            this.cpu.setMapperIrq(false);
        }
    }
}

