/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.codemasters;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class GoldenFive
extends Mapper {
    private static final long serialVersionUID = 0L;

    public GoldenFive(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.setPrgBank(2, 0);
        this.setPrgBank(3, 15);
        this.setChrBank(0);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address >= 49152) {
            this.prgBanks[2] = this.prgBanks[2] & 0x1C0000 | (value & 0xF) << 14;
        } else if ((address & 0xE000) == 32768 && BitUtil.getBitBool(value, 3)) {
            this.prgBanks[2] = (value << 4 & 0x70) << 14 | this.prgBanks[2] & 0x3C000;
            this.setPrgBank(3, value << 4 & 0x70 | 0xF);
        }
    }
}

