/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.codemasters;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper232
extends Mapper {
    private static final long serialVersionUID = 0L;

    public Mapper232(CartFile cartFile) {
        super(cartFile, 4, 0);
        this.prgBanks[3] = 49152;
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address < 49152) {
            this.writeBlock(value);
        } else {
            this.writePage(value);
        }
    }

    private void writeBlock(int value) {
        int block = (value & 0x18) << 13;
        this.prgBanks[2] = this.prgBanks[2] & 0xC000 | block;
        this.prgBanks[3] = 0xC000 | block;
    }

    private void writePage(int value) {
        this.prgBanks[2] = this.prgBanks[2] & 0x30000 | (value & 3) << 14;
    }
}

