/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.colordreams;

import nintaco.files.NesFile;
import nintaco.mappers.nintendo.GxROM;

public class RumbleStation
extends GxROM {
    private static final long serialVersionUID = 0L;

    public RumbleStation(NesFile nesFile) {
        super(nesFile);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address < 24576) {
            this.memory[address] = value;
        } else if (address < 32768) {
            this.writeBanksHigh(value);
        } else {
            this.writeBanksLow(value);
        }
    }

    private void writeBanksHigh(int value) {
        this.prgBanks[1] = this.prgBanks[1] & 0x8000 | (value & 0xF) << 16;
        this.chrBanks[0] = this.chrBanks[0] & 0xE000 | (value & 0xF0) << 12;
    }

    private void writeBanksLow(int value) {
        this.prgBanks[1] = this.prgBanks[1] & 0xF0000 | (value & 1) << 15;
        this.chrBanks[0] = this.chrBanks[0] & 0xF0000 | (value & 0x70) << 9;
    }
}

