/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.homebrew;

import nintaco.files.NesFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class MagicFloor
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] ntMappings = new int[8];

    public MagicFloor(NesFile nesFile) {
        super(nesFile, 2, 1);
        int mirroring = nesFile.getMirroring();
        if (mirroring == 4) {
            mirroring = BitUtil.getBitBool(nesFile.getHeader()[6], 0) ? 3 : 2;
        }
        int bit = 0;
        switch (mirroring) {
            case 0: {
                bit = 0;
                break;
            }
            case 1: {
                bit = 1;
                break;
            }
            case 2: {
                bit = 2;
                break;
            }
            case 3: {
                bit = 3;
            }
        }
        for (int i = 7; i >= 0; --i) {
            this.ntMappings[i] = 0x2000 | BitUtil.getBit(i, bit) << 10;
        }
    }

    @Override
    public void init() {
        this.setPrgBank(0);
    }

    @Override
    public int maskVRAMAddress(int address) {
        if ((address &= this.vramMask) >= 8192 && address <= 16127) {
            address = this.ntMappings[address >> 10 & 7] | address & 0x3FF;
        }
        return address;
    }
}

