/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.homebrew;

import nintaco.files.NesFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Streemerz
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] bankSizeMasks = new int[4];
    private int register;
    private int mirroring;
    private int bankMode;
    private int innerPrg = 15;
    private int outerPrg = 63;

    public Streemerz(NesFile nesFile) {
        super(nesFile, 4, 1);
        this.xram = new int[32768];
        this.updatePrgBanks();
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.xram[this.chrBanks[0] | address];
        }
        return this.vram[address];
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192) {
            this.xram[this.chrBanks[0] | address] = value;
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF000) == 20480) {
            this.writeRegisterIndex(value);
        } else if (address >= 32768) {
            this.writeRegisterValue(value);
        } else {
            this.memory[address] = value;
        }
    }

    private void writeRegisterIndex(int value) {
        this.register = value & 0x81;
    }

    private void writeRegisterValue(int value) {
        value &= 0x3F;
        switch (this.register) {
            case 0: {
                this.writeChrRegister(value);
                break;
            }
            case 1: {
                this.writePrgRegister(value);
                break;
            }
            case 128: {
                this.writeMode(value);
                break;
            }
            case 129: {
                this.writeOuterPrgRegister(value);
            }
        }
    }

    private void writeChrRegister(int value) {
        this.setChrBank(value & 3);
        this.overrideNametableMirroring(value);
    }

    private void writePrgRegister(int value) {
        this.innerPrg = value & 0xF;
        this.overrideNametableMirroring(value);
        this.updatePrgBanks();
    }

    private void writeMode(int value) {
        this.bankMode = value >> 2 & 0xF;
        this.setNametableMirroring(value);
        this.updatePrgBanks();
    }

    private void writeOuterPrgRegister(int value) {
        this.outerPrg = (value & 0x3F) << 1;
        this.updatePrgBanks();
    }

    private void updatePrgBanks() {
        this.updatePrgBank(2, this.bankMode, this.outerPrg, this.innerPrg);
        this.updatePrgBank(3, this.bankMode, this.outerPrg, this.innerPrg);
    }

    private void updatePrgBank(int bank, int bankMode, int outerBank, int innerBank) {
        int cpuA14 = bank - 2;
        if (((bankMode ^ cpuA14) & 3) == 2) {
            bankMode = 0;
        }
        if ((bankMode & 2) == 0) {
            innerBank = innerBank << 1 | cpuA14;
        }
        this.setPrgBank(bank, (innerBank ^ outerBank) & bankSizeMasks[bankMode >> 2 & 3] ^ outerBank);
    }

    private void overrideNametableMirroring(int value) {
        if (this.mirroring < 2) {
            this.setNametableMirroring(BitUtil.getBit(value, 4));
        }
    }

    @Override
    public void setNametableMirroring(int nametableMirroring) {
        this.mirroring = nametableMirroring & 3;
        switch (this.mirroring) {
            case 0: {
                super.setNametableMirroring(2);
                break;
            }
            case 1: {
                super.setNametableMirroring(3);
                break;
            }
            case 2: {
                super.setNametableMirroring(0);
                break;
            }
            case 3: {
                super.setNametableMirroring(1);
            }
        }
    }

    static {
        for (int i = 0; i < bankSizeMasks.length; ++i) {
            Streemerz.bankSizeMasks[i] = (2 << i) - 1;
        }
    }
}

