/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.homebrew;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class UNROM512
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean mapperControlledMirroring;

    public UNROM512(CartFile cartFile) {
        super(cartFile, 4, 1);
        this.setPrgBank(3, -1);
    }

    @Override
    protected int getChrRamSize(CartFile cartFile) {
        return 32768;
    }

    @Override
    public void init() {
        this.mapperControlledMirroring = this.nametableMirroring >= 2;
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.setPrgBank(2, value & 0x1F);
        this.setChrBank(value >> 5 & 3);
        if (this.mapperControlledMirroring) {
            this.setNametableMirroring(BitUtil.getBit(value, 7) + 2);
        }
    }
}

