/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import nintaco.files.CartFile;
import nintaco.mappers.jy.JY;
import nintaco.util.BitUtil;

public class Mapper282
extends JY {
    private static final long serialVersionUID = 0L;
    protected int prgBlockOffset;
    protected int chrBlockOffset;

    public Mapper282(CartFile cartFile) {
        super(cartFile, 282);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        super.setPrgBank(bank, this.prgBlockOffset | value & 0x1F);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        super.setChrBank(bank, this.chrBlockOffset | value);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF003) == 53251) {
            this.prgBlockOffset = (value & 6) << 4;
            this.chrBlockOffset = value & 1;
            if (BitUtil.getBitBool(value, 4)) {
                this.chrBlockOffset |= (value & 8) >> 2;
            }
            this.chrBlockOffset <<= 8;
            this.updatePrgBanks();
            this.updateChrBanks();
        } else {
            super.writeMemory(address, value);
        }
    }
}

