/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper351
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int chrBase;
    private int prgBase;
    private int mode;

    public Mapper351(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.mode = 0;
        this.prgBase = 0;
        this.chrBase = 0;
        this.updateState();
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void writeChrRomBase(int value) {
        this.chrBase = (0xFC & value) << 1;
        this.updateState();
    }

    private void writePrgRomBase(int value) {
        this.prgBase = 0xFC & value;
        this.updateState();
    }

    private void writeBankingMode(int value) {
        this.mode = 0xF0 & value;
        this.updateState();
    }

    @Override
    protected void updatePrgBanks() {
        if (BitUtil.getBitBool(this.mode, 7)) {
            if (BitUtil.getBitBool(this.mode, 6)) {
                this.set2PrgBanks(4, this.prgBase >> 1);
                this.set2PrgBanks(6, this.prgBase >> 1);
            } else {
                this.set4PrgBanks(4, this.prgBase >> 1);
            }
        } else {
            super.updatePrgBanks();
        }
    }

    private void updateState() {
        if (BitUtil.getBitBool(this.mode, 7)) {
            this.setPrgBlock(0, -1);
            this.setChrBlock(this.chrBase, 31);
        } else {
            this.setPrgBlock(this.prgBase >> 1, BitUtil.getBitBool(this.mode, 5) ? 15 : 31);
            this.setChrBlock(this.chrBase, BitUtil.getBitBool(this.mode, 5) ? 127 : 255);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        switch (address & 0xF003) {
            case 20480: {
                this.writeChrRomBase(value);
                break;
            }
            case 20481: {
                this.writePrgRomBase(value);
                break;
            }
            case 20482: {
                this.writeBankingMode(value);
                break;
            }
            default: {
                super.writeMemory(address, value);
            }
        }
    }
}

