/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import nintaco.files.CartFile;
import nintaco.mappers.jy.JY;
import nintaco.util.BitUtil;

public class Mapper358
extends JY {
    private static final long serialVersionUID = 0L;
    protected int prgBlockMask = -1;
    protected int prgBlockOffset;
    protected int chrBlockMask = -1;
    protected int chrBlockOffset;

    public Mapper358(CartFile cartFile) {
        super(cartFile, 358);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        super.setPrgBank(bank, this.prgBlockOffset | 0x3F & value);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        super.setChrBank(bank, this.chrBlockOffset | this.chrBlockMask & value);
    }

    private void writeOuterBankRegister(int value) {
        this.prgBlockOffset = (value & 6) << 5;
        if (BitUtil.getBitBool(value, 5)) {
            this.chrBlockOffset = 512;
            this.chrBlockMask = 511;
        } else {
            this.chrBlockOffset = (value & 1) << 8;
            this.chrBlockMask = 255;
        }
        this.updateChrBanks();
        this.updatePrgBanks();
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((0xF803 & address) == 53251) {
            this.writeOuterBankRegister(value);
        }
        super.writeMemory(address, value);
    }
}

