/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import nintaco.files.CartFile;
import nintaco.mappers.konami.VRC2And4;

public class Mapper362
extends VRC2And4 {
    private static final long serialVersionUID = 0L;
    protected int prgBlockOffset;
    protected int chrBlockOffset;

    public Mapper362(CartFile cartFile) {
        super(cartFile);
        this.variant = 8;
        this.useHeuristics = false;
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            int bank = address >> 10;
            int value = (this.chrHigh[bank] << 4 | this.chrLow[bank]) & 0x180;
            this.prgBlockOffset = value >> 3;
            this.chrBlockOffset = value;
            this.updateBanks();
        }
        return super.readVRAM(address);
    }

    @Override
    protected void writeIrqAcknowledge() {
        this.cpu.setMapperIrq(false);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        super.setPrgBank(bank, this.prgBlockOffset | 0xF & value);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        super.setChrBank(bank, this.chrBlockOffset | 0x7F & value);
    }
}

