/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.kaiser;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Kaiser7017
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int bank2;
    private int mirroring;
    private int irqCounter;
    private boolean irqEnabled;

    public Kaiser7017(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.updateState();
        this.setChrBank(0);
    }

    private void updateState() {
        this.setPrgBank(2, this.bank2);
        this.setPrgBank(3, 2);
        this.setNametableMirroring(this.mirroring);
    }

    @Override
    public int readMemory(int address) {
        if (address == 16432) {
            int value = BitUtil.toBit(this.cpu.getMapperIrq());
            this.cpu.setMapperIrq(false);
            return value;
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address >= 16416 && address < 24576) {
            if ((address & 0xFF00) == 18944) {
                this.bank2 = address >> 2 & 3 | address >> 4 & 4;
            } else if ((address & 0xFF00) == 20736) {
                this.updateState();
            } else if (address == 16416) {
                this.cpu.setMapperIrq(false);
                this.irqCounter = this.irqCounter & 0xFF00 | value;
            } else if (address == 16417) {
                this.cpu.setMapperIrq(false);
                this.irqCounter = value << 8 | this.irqCounter & 0xFF;
                this.irqEnabled = true;
            } else if (address == 16421) {
                this.mirroring = (value & 8) >> 3;
            }
        }
    }

    @Override
    public void update() {
        if (this.irqEnabled && --this.irqCounter <= 0) {
            this.irqEnabled = false;
            this.cpu.setMapperIrq(true);
        }
    }
}

