/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami.vrc6;

import java.io.Serializable;
import nintaco.util.BitUtil;

public abstract class VrcChannel
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected boolean runOscillator;
    protected int frequencyShift;
    protected int frequencyReload;
    protected int frequency;
    protected int outputLevel;
    protected boolean enabled;

    public void writeFrequencyControl(int value) {
        this.runOscillator = !BitUtil.getBitBool(value, 0);
        switch (value >> 1 & 3) {
            case 0: {
                this.frequencyShift = 0;
                break;
            }
            case 1: {
                this.frequencyShift = 4;
                break;
            }
            case 2: 
            case 3: {
                this.frequencyShift = 8;
            }
        }
    }

    public void writeFrequencyLow(int value) {
        this.frequencyReload = 0xF00 & this.frequencyReload | value;
    }

    public void writeFrequencyHigh(int value) {
        this.frequencyReload = (value & 0xF) << 8 | 0xFF & this.frequencyReload;
        this.enabled = BitUtil.getBitBool(value, 7);
    }

    public int getValue() {
        return this.enabled ? this.outputLevel : 0;
    }
}

