/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.namco;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.mappers.namco.Namco163Audio;
import nintaco.util.BitUtil;

public class Mapper330
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final Namco163Audio audio = new Namco163Audio();
    private int irqCounter;

    public Mapper330(CartFile cartFile) {
        super(cartFile, 8, 8, 32768, 24576);
    }

    @Override
    public void init() {
        this.setPrgBank(3, 0);
        this.setPrgBank(4, 0);
        this.setPrgBank(5, 1);
        this.setPrgBank(6, 2);
        this.setPrgBank(7, -1);
    }

    @Override
    public void update() {
        this.audio.update();
        if ((this.irqCounter & 0x8000) != 0) {
            ++this.irqCounter;
            this.irqCounter &= 0xFFFF;
            if (this.irqCounter == 0) {
                this.cpu.setMapperIrq(true);
            }
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if (!this.audio.writeRegister(address, value)) {
            super.writeMemory(address, value);
        }
    }

    private void writeChrAndIrq(int address, int value) {
        if ((address & 0x4400) == 1024) {
            if (BitUtil.getBitBool(address, 13)) {
                this.irqCounter = value << 8 | this.irqCounter & 0xFF;
                this.cpu.setMapperIrq(false);
            } else {
                this.irqCounter = this.irqCounter & 0xFF00 | value;
            }
        } else {
            this.setChrBank(address >> 11 & 7, value);
        }
    }

    private void writeNametableMirroring(int address, int value) {
        this.setNametable(address >> 11 & 3, value & 1);
    }

    private void writePrg(int address, int value) {
        int bank = 4 | address >> 11 & 3;
        if (bank != 7) {
            this.setPrgBank(bank, value);
        }
    }

    @Override
    public void writeRegister(int address, int value) {
        switch (address >> 13) {
            case 4: 
            case 5: {
                this.writeChrAndIrq(address, value);
                break;
            }
            case 6: {
                this.writeNametableMirroring(address, value);
                break;
            }
            case 7: {
                this.writePrg(address, value);
            }
        }
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }
}

