/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.namco;

import java.util.Arrays;
import nintaco.mappers.Audio;
import nintaco.util.BitUtil;

public final class Namco163Audio
extends Audio {
    private static final long serialVersionUID = 0L;
    private static final int MIX_RANGE = 42190;
    private static float volume;
    private final int[] soundRAM = new int[128];
    private final int[] outputs = new int[8];
    private int soundSample;
    private int soundCpuCycleCount;
    private int soundChannelIndex;
    private int soundAddress;
    private int enabledChannels = 1;
    private boolean soundEnabled;
    private boolean incrementSoundAddress;

    public static void setVolume(int volume) {
        Namco163Audio.volume = (float)volume / 100.0f;
    }

    @Override
    public void reset() {
        this.soundSample = 0;
        this.soundCpuCycleCount = 0;
        this.soundChannelIndex = 0;
        this.soundAddress = 0;
        this.enabledChannels = 1;
        this.soundEnabled = false;
        this.incrementSoundAddress = false;
        Arrays.fill(this.soundRAM, 0);
        Arrays.fill(this.outputs, 0);
    }

    @Override
    public int readRegister(int address) {
        return (address & 0xF800) == 18432 ? this.readSoundData() : -1;
    }

    @Override
    public boolean writeRegister(int address, int value) {
        switch (address & 0xF800) {
            case 18432: {
                this.writeSoundData(value);
                break;
            }
            case 57344: {
                this.soundEnabled = !BitUtil.getBitBool(value, 6);
                break;
            }
            case 63488: {
                this.soundAddress = value & 0x7F;
                this.incrementSoundAddress = BitUtil.getBitBool(value, 7);
            }
        }
        return false;
    }

    protected void writeSoundData(int value) {
        this.soundRAM[this.soundAddress] = value;
        if (this.soundAddress == 127) {
            this.enabledChannels = (value >> 4 & 7) + 1;
        }
        if (this.incrementSoundAddress) {
            this.soundAddress = this.soundAddress + 1 & 0x7F;
        }
    }

    protected void updateSoundChannel() {
        int addr = 64 + (this.soundChannelIndex << 3);
        int freq = (this.soundRAM[addr + 4] & 3) << 16 | this.soundRAM[addr + 2] << 8 | this.soundRAM[addr];
        int phase = this.soundRAM[addr + 5] << 16 | this.soundRAM[addr + 3] << 8 | this.soundRAM[addr + 1];
        int length = 256 - (this.soundRAM[addr + 4] & 0xFC);
        int offset = this.soundRAM[addr + 6];
        int volume = this.soundRAM[addr + 7] & 0xF;
        phase = (phase + freq) % (length << 16);
        this.outputs[this.soundChannelIndex] = (8 - this.sample((phase >> 16) + offset & 0xFF)) * volume;
        this.soundRAM[addr + 1] = phase & 0xFF;
        this.soundRAM[addr + 3] = phase >> 8 & 0xFF;
        this.soundRAM[addr + 5] = phase >> 16 & 0xFF;
        this.soundSample = 0;
        for (int i = 8 - this.enabledChannels; i < 8; ++i) {
            this.soundSample += this.outputs[i];
        }
        this.soundSample = 32768 + this.soundSample * 42190 / (225 * (this.enabledChannels <= 6 ? this.enabledChannels : 6));
    }

    protected int sample(int x) {
        return this.soundRAM[x >> 1] >> ((x & 1) << 2) & 0xF;
    }

    protected int readSoundData() {
        int value = this.soundRAM[this.soundAddress];
        if (this.incrementSoundAddress) {
            this.soundAddress = this.soundAddress + 1 & 0x7F;
        }
        return value;
    }

    @Override
    public void update() {
        if (++this.soundCpuCycleCount == 15) {
            this.soundCpuCycleCount = 0;
            if (--this.soundChannelIndex < 8 - this.enabledChannels) {
                this.soundChannelIndex = 7;
            }
            this.updateSoundChannel();
        }
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    @Override
    public int getAudioMixerScale() {
        return 23345;
    }

    @Override
    public float getAudioSample() {
        return volume * (float)this.soundSample;
    }

    static {
        Namco163Audio.setVolume(100);
    }
}

