/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class MMC1
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected static final int[] MIRRORING = new int[]{2, 3, 0, 1};
    protected final int[] chrBankRegs = new int[2];
    protected final boolean largePrgROM;
    protected final boolean prgBanking;
    protected long lastCycleCount;
    protected int lastUpdatedChrBankReg;
    protected int shiftRegister = 16;
    protected int controlRegister;
    protected int prgBankMode;
    protected int prgBankReg;
    protected boolean chrBankMode;
    protected boolean prgRamEnabled;

    public MMC1(CartFile cartFile) {
        super(cartFile, 4, 2);
        this.largePrgROM = cartFile.getPrgRomLength() == 524288;
        this.prgBanking = cartFile.getSubmapperNumber() != 5;
    }

    @Override
    public void init() {
        this.prgRamEnabled = true;
        this.writeControl(12);
        this.writeChrBankReg(0, 0);
        this.writeChrBankReg(1, 0);
        this.setPrgBank(2, 0);
        this.setPrgBank(3, this.prgBanking ? -1 : 1);
        this.updateBanks();
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) != 24576 || this.prgRamEnabled) {
            super.writeMemory(address, value);
        }
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xE000) != 24576 || this.prgRamEnabled) {
            return super.readMemory(address);
        }
        return 0;
    }

    @Override
    protected void writeRegister(int address, int value) {
        long cycleCount = this.cpu.getCycleCounter();
        if (cycleCount - this.lastCycleCount >= 2L) {
            if (BitUtil.getBitBool(value, 7)) {
                this.shiftRegister = 16;
                this.writeControl(this.controlRegister | 0xC);
            } else {
                int register = address & 0xE000;
                boolean write = BitUtil.getBitBool(this.shiftRegister, 0);
                this.shiftRegister = this.shiftRegister >> 1 | (value & 1) << 4;
                if (write) {
                    switch (register) {
                        case 32768: {
                            this.writeControl(this.shiftRegister);
                            break;
                        }
                        case 40960: {
                            this.writeChrBankReg(0, this.shiftRegister);
                            break;
                        }
                        case 49152: {
                            this.writeChrBankReg(1, this.shiftRegister);
                            break;
                        }
                        case 57344: {
                            this.writePrgBankReg(this.shiftRegister);
                        }
                    }
                    this.shiftRegister = 16;
                }
            }
        }
        this.lastCycleCount = cycleCount;
    }

    protected void writeControl(int value) {
        this.controlRegister = value;
        this.setNametableMirroring(MIRRORING[value & 3]);
        this.prgBankMode = value >> 2 & 3;
        this.chrBankMode = BitUtil.getBitBool(value, 4);
        this.updateBanks();
    }

    protected void writeChrBankReg(int bank, int value) {
        this.chrBankRegs[bank] = value & 0x1F;
        this.lastUpdatedChrBankReg = bank;
        this.updateBanks();
    }

    protected void writePrgBankReg(int value) {
        this.prgBankReg = value & 0xF;
        this.prgRamEnabled = !BitUtil.getBitBool(value, 4);
        this.updateBanks();
    }

    protected void updateBanks() {
        if (this.prgBanking) {
            int prgBlock = this.largePrgROM ? this.chrBankRegs[this.chrBankMode && this.lastUpdatedChrBankReg == 1 ? 1 : 0] & 0x10 : 0;
            switch (this.prgBankMode) {
                case 0: 
                case 1: {
                    int bank = prgBlock | this.prgBankReg & 0xFE;
                    this.setPrgBank(2, bank);
                    this.setPrgBank(3, bank | 1);
                    break;
                }
                case 2: {
                    this.setPrgBank(2, prgBlock);
                    this.setPrgBank(3, prgBlock | this.prgBankReg);
                    break;
                }
                case 3: {
                    this.setPrgBank(2, prgBlock | this.prgBankReg);
                    this.setPrgBank(3, prgBlock | 0xF);
                }
            }
        }
        if (this.chrBankMode) {
            this.setChrBank(0, this.chrBankRegs[0]);
            this.setChrBank(1, this.chrBankRegs[1]);
        } else {
            this.setChrBank(0, this.chrBankRegs[0] & 0x1E);
            this.setChrBank(1, this.chrBankRegs[0] & 0x1E | 1);
        }
    }
}

