/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class MMC3
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int MMC3C = 0;
    private static final int MMC6B = 1;
    private static final int MC_ACC = 3;
    private static final int MMC3A = 4;
    private static final int MMC3B = 5;
    protected final int[] R = new int[]{0, 2, 4, 5, 6, 7, -4, -3};
    protected boolean mmc3a;
    protected boolean mc_acc;
    protected boolean requestIrqOnA12Fall;
    protected boolean chrMode;
    protected boolean prgMode;
    protected boolean prgRamWritesEnabled;
    protected boolean prgRamChipEnabled;
    protected boolean irqEnabled;
    protected boolean irqReloadRequest;
    protected int irqCounter;
    protected int irqReloadValue;
    protected int irqResetDelay;
    protected int register;
    protected int prgBlockMask = -1;
    protected int prgBlockOffset;
    protected int chrBlockMask = -1;
    protected int chrBlockOffset;

    public MMC3(CartFile cartFile) {
        super(cartFile, 8, 8);
        switch (cartFile.getSubmapperNumber()) {
            case 3: {
                this.mc_acc = true;
                break;
            }
            case 4: {
                this.mmc3a = true;
            }
        }
    }

    @Override
    public void init() {
        this.updateBanks();
    }

    private void triggerIRQ() {
        if (this.mc_acc) {
            this.requestIrqOnA12Fall = true;
        } else {
            this.cpu.setMapperIrq(true);
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        boolean a12;
        if (this.irqResetDelay > 0) {
            --this.irqResetDelay;
        }
        boolean bl = a12 = (address & 0x1000) != 0;
        if (a12) {
            if (this.irqResetDelay == 0) {
                boolean decrementedToZero = false;
                if (this.irqCounter > 0) {
                    --this.irqCounter;
                    decrementedToZero = this.irqCounter == 0;
                } else {
                    this.irqCounter = this.irqReloadValue;
                }
                if (this.irqReloadRequest) {
                    this.irqReloadRequest = false;
                    this.irqCounter = this.irqReloadValue;
                    boolean bl2 = decrementedToZero = this.irqCounter == 0;
                }
                if (this.mmc3a) {
                    if (decrementedToZero && this.irqEnabled) {
                        this.triggerIRQ();
                    }
                } else if (this.irqCounter == 0 && this.irqEnabled) {
                    this.triggerIRQ();
                }
            }
            this.irqResetDelay = this.mc_acc ? 35 : 8;
        } else if (this.requestIrqOnA12Fall) {
            this.requestIrqOnA12Fall = false;
            this.cpu.setMapperIrq(true);
        }
    }

    @Override
    public void writeRegister(int address, int value) {
        switch (address & 0xE001) {
            case 32768: {
                this.writeBankSelect(value);
                break;
            }
            case 32769: {
                this.writeBankData(value);
                break;
            }
            case 40960: {
                this.writeMirroring(value);
                break;
            }
            case 40961: {
                this.writePrgRamProtect(value);
                break;
            }
            case 49152: {
                this.writeIrqLatch(value);
                break;
            }
            case 49153: {
                this.writeIrqReload();
                break;
            }
            case 57344: {
                this.writeIrqDisable();
                break;
            }
            case 57345: {
                this.writeIrqEnable();
            }
        }
    }

    protected void updateBanks() {
        this.updateChrBanks();
        this.updatePrgBanks();
    }

    protected void updateChrBanks() {
        if (this.chrMode) {
            this.setChrBank(0, this.R[2]);
            this.setChrBank(1, this.R[3]);
            this.setChrBank(2, this.R[4]);
            this.setChrBank(3, this.R[5]);
            this.setChrBank(4, this.R[0] & 0xFE);
            this.setChrBank(5, this.R[0] | 1);
            this.setChrBank(6, this.R[1] & 0xFE);
            this.setChrBank(7, this.R[1] | 1);
        } else {
            this.setChrBank(0, this.R[0] & 0xFE);
            this.setChrBank(1, this.R[0] | 1);
            this.setChrBank(2, this.R[1] & 0xFE);
            this.setChrBank(3, this.R[1] | 1);
            this.setChrBank(4, this.R[2]);
            this.setChrBank(5, this.R[3]);
            this.setChrBank(6, this.R[4]);
            this.setChrBank(7, this.R[5]);
        }
    }

    protected void updatePrgBanks() {
        if (this.prgMode) {
            this.setPrgBank(4, -2);
            this.setPrgBank(5, this.R[7]);
            this.setPrgBank(6, this.R[6]);
            this.setPrgBank(7, -1);
        } else {
            this.setPrgBank(4, this.R[6]);
            this.setPrgBank(5, this.R[7]);
            this.setPrgBank(6, -2);
            this.setPrgBank(7, -1);
        }
    }

    protected void writeBankSelect(int value) {
        this.chrMode = BitUtil.getBitBool(value, 7);
        this.prgMode = BitUtil.getBitBool(value, 6);
        this.register = value & 7;
        this.updateBanks();
    }

    protected void writeBankData(int value) {
        this.R[this.register] = value;
        if (this.register < 6) {
            this.updateChrBanks();
        } else {
            this.updatePrgBanks();
        }
    }

    protected void writeMirroring(int value) {
        if (this.nametableMirroring < 2) {
            this.setNametableMirroring(value & 1);
        }
    }

    protected void writePrgRamProtect(int value) {
        this.prgRamChipEnabled = BitUtil.getBitBool(value, 7);
        this.prgRamWritesEnabled = !BitUtil.getBitBool(value, 6);
    }

    protected void writeIrqLatch(int value) {
        this.irqReloadValue = value;
    }

    protected void writeIrqReload() {
        this.irqCounter = 0;
        this.irqReloadRequest = true;
    }

    protected void writeIrqDisable() {
        this.irqEnabled = false;
        this.cpu.setMapperIrq(false);
    }

    protected void writeIrqEnable() {
        this.irqEnabled = true;
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        super.setPrgBank(bank, this.prgBlockOffset | this.prgBlockMask & value);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        super.setChrBank(bank, this.chrBlockOffset | this.chrBlockMask & value);
    }

    protected void setPrgBlockMask(int prgBlockMask) {
        this.prgBlockMask = prgBlockMask;
        this.updatePrgBanks();
    }

    protected void setPrgBlockOffset(int prgBlockOffset) {
        this.prgBlockOffset = prgBlockOffset;
        this.updatePrgBanks();
    }

    protected void setPrgBlock(int prgBlockOffset, int prgBlockMask) {
        this.prgBlockOffset = prgBlockOffset;
        this.prgBlockMask = prgBlockMask;
        this.updatePrgBanks();
    }

    public void setChrBlockMask(int chrBlockMask) {
        this.chrBlockMask = chrBlockMask;
        this.updateChrBanks();
    }

    protected void setChrBlockOffset(int chrBlockOffset) {
        this.chrBlockOffset = chrBlockOffset;
        this.updateChrBanks();
    }

    protected void setChrBlock(int chrBlockOffset, int chrBlockMask) {
        this.chrBlockOffset = chrBlockOffset;
        this.chrBlockMask = chrBlockMask;
        this.updateChrBanks();
    }

    protected void setBlock(int prgBlockOffset, int prgBlockMask, int chrBlockOffset, int chrBlockMask) {
        this.prgBlockOffset = prgBlockOffset;
        this.prgBlockMask = prgBlockMask;
        this.chrBlockOffset = chrBlockOffset;
        this.chrBlockMask = chrBlockMask;
        this.updateBanks();
    }
}

