/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.vs;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class VsUniSystem
extends Mapper {
    private static final long serialVersionUID = 0L;

    public VsUniSystem(CartFile cartFile) {
        super(cartFile, 8, 1);
        this.setNametableMirroring(4);
        this.setPrgBank(4, 0);
        this.setPrgBank(5, 1);
        this.setPrgBank(6, 2);
        this.setPrgBank(7, 3);
    }

    @Override
    public void writeCpuMemory(int address, int value) {
        if (address == 16406) {
            this.writeBankSelect(value);
        }
        super.writeCpuMemory(address, value);
    }

    private void writeBankSelect(int value) {
        int bank = BitUtil.getBit(value, 2);
        this.setChrBank(bank);
        if (this.prgRomLength > 32768) {
            this.setPrgBank(4, bank << 2);
        }
    }
}

