/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nsf;

import java.util.Arrays;
import nintaco.files.NsfFile;
import nintaco.gui.nsf.NsfPrefs;
import nintaco.mappers.Audio;
import nintaco.mappers.Mapper;
import nintaco.mappers.konami.vrc6.VRC6Audio;
import nintaco.mappers.konami.vrc7.VRC7Audio;
import nintaco.mappers.namco.Namco163Audio;
import nintaco.mappers.nintendo.fds.FdsAudio;
import nintaco.mappers.nintendo.mmc5.MMC5Audio;
import nintaco.mappers.sunsoft.fme7.Sunsoft5BAudio;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;

public class NsfMapper
extends Mapper {
    private static final long serialVersionUID = 0L;
    public static final int DEFAULT_FADE_SECONDS = 8;
    private static final int STATE_NOT_PLAYING = 0;
    private static final int STATE_SONG_REQUESTED = 1;
    private static final int STATE_PLAYING_SONG = 2;
    private final int chipCount;
    private final int audioMixerScale;
    private final Audio[] audios;
    private final FdsAudio fdsAudio;
    private final MMC5Audio mmc5Audio;
    private final Sunsoft5BAudio sunsoft5BAudio;
    private int state = 0;
    private int requestedSong;
    private boolean songPaused;
    private volatile boolean automaticallyAdvanceTrack;
    private volatile int silenceSeconds;
    private volatile boolean defaultTrackLength;
    private volatile int trackLengthMinutes;
    private volatile long songCpuCycles;
    private boolean fixedLengthTrack;
    private long trackCycles = Long.MAX_VALUE;
    private long fadeCycles;
    private float volume = 1.0f;
    private float deltaVolume;
    private transient NsfFile nsfFile;

    public NsfMapper(NsfFile nsfFile) {
        super(nsfFile);
        this.nsfFile = nsfFile;
        NsfPrefs prefs = AppPrefs.getInstance().getNsfPrefs();
        this.automaticallyAdvanceTrack = prefs.isAutomaticallyAdvanceTrack();
        this.silenceSeconds = prefs.getSilenceSeconds();
        this.defaultTrackLength = prefs.isDefaultTrackLength();
        this.trackLengthMinutes = prefs.getTrackLengthMinutes();
        this.chipCount = nsfFile.getChipCount();
        this.audios = new Audio[this.chipCount];
        int i = 0;
        if (nsfFile.usesFdsAudio()) {
            int n = i++;
            this.fdsAudio = new FdsAudio();
            this.audios[n] = this.fdsAudio;
        } else {
            this.fdsAudio = null;
        }
        if (nsfFile.usesMMC5Audio()) {
            int n = i++;
            this.mmc5Audio = new MMC5Audio(this.getTVSystem());
            this.audios[n] = this.mmc5Audio;
        } else {
            this.mmc5Audio = null;
        }
        if (nsfFile.usesNamco163Audio()) {
            this.audios[i++] = new Namco163Audio();
        }
        if (nsfFile.usesSunsoft5BAudio()) {
            int n = i++;
            this.sunsoft5BAudio = new Sunsoft5BAudio();
            this.audios[n] = this.sunsoft5BAudio;
        } else {
            this.sunsoft5BAudio = null;
        }
        if (nsfFile.usesVRC6Audio()) {
            this.audios[i++] = new VRC6Audio();
        }
        if (nsfFile.usesVRC7Audio()) {
            this.audios[i++] = new VRC7Audio();
        }
        int sum = 0;
        for (i = this.chipCount - 1; i >= 0; --i) {
            this.audios[i].init();
            sum += this.audios[i].getAudioMixerScale();
        }
        this.audioMixerScale = this.chipCount == 0 ? 65535 : sum / this.chipCount;
        this.requestSong(nsfFile.getStartingSong());
    }

    @Override
    public void setTVSystem(TVSystem tvSystem) {
        super.setTVSystem(tvSystem);
        if (this.mmc5Audio != null) {
            this.mmc5Audio.setTVSystem(tvSystem);
        }
        if (this.sunsoft5BAudio != null) {
            this.sunsoft5BAudio.setTVSystem(tvSystem);
        }
    }

    @Override
    public void setNsfOptions(boolean automaticallyAdvanceTrack, int idleSeconds, boolean defaultTrackLength, int trackLengthMinutes) {
        this.automaticallyAdvanceTrack = automaticallyAdvanceTrack;
        this.silenceSeconds = idleSeconds;
        this.defaultTrackLength = defaultTrackLength;
        this.trackLengthMinutes = trackLengthMinutes;
    }

    @Override
    public void setSongPaused(boolean songPaused) {
        this.songPaused = songPaused;
        this.apu.setFadeVolume(songPaused ? 0.0f : this.volume);
        if (!songPaused) {
            this.apu.clearInactiveSeconds();
        }
    }

    @Override
    public boolean isNsfMapper() {
        return true;
    }

    @Override
    public boolean isSongPaused() {
        return this.songPaused;
    }

    @Override
    public void requestSong(int songNumber) {
        this.requestedSong = songNumber;
        this.trackCycles = Long.MAX_VALUE;
        this.songCpuCycles = 0L;
        this.volume = 1.0f;
        this.state = 1;
    }

    public int getRequestedSong() {
        return this.requestedSong;
    }

    private void initSong(int songNumber) {
        int i;
        this.initBanks();
        for (i = 16403; i >= 16384; --i) {
            this.writeCpuMemory(i, 0);
        }
        this.writeCpuMemory(16405, 15);
        this.writeCpuMemory(16407, 64);
        for (i = this.chipCount - 1; i >= 0; --i) {
            this.audios[i].reset();
        }
        this.cpu.setS(255);
        this.cpu.setA(songNumber);
        this.cpu.setX(this.ntsc ? 0 : 1);
    }

    private void initBanks() {
        Arrays.fill(this.memory, 0);
        if (this.nsfFile.isBankSwitched()) {
            int[] initBanks = this.nsfFile.getInitBanks();
            for (int i = 7; i >= 0; --i) {
                this.setPrgBank(i + 8, initBanks[i]);
            }
            if (this.fdsAudio != null) {
                this.setPrgBank(6, initBanks[6]);
                this.setPrgBank(7, initBanks[7]);
            }
        } else {
            int bank = this.nsfFile.getLoadAddress() >> 12;
            int value = 0;
            while (bank < 16) {
                this.setPrgBank(bank, value);
                ++bank;
                ++value;
            }
        }
    }

    public void jumpSubroutine(int address) {
        this.memory[510] = 252;
        this.memory[511] = 79;
        this.cpu.setS(253);
        this.cpu.setI(1);
        this.cpu.setPC(address);
    }

    @Override
    public int readCpuMemory(int address) {
        switch (address) {
            case 20477: {
                return 76;
            }
            case 20478: {
                return 253;
            }
            case 20479: {
                return 79;
            }
        }
        return super.readCpuMemory(address);
    }

    @Override
    public int readMemory(int address) {
        if (this.mmc5Audio != null && address >= 24576) {
            this.mmc5Audio.updatePcmValue(address, this.memory[address]);
        }
        for (int i = this.audios.length - 1; i >= 0; --i) {
            int value = this.audios[i].readRegister(address);
            if (value < 0) continue;
            return value;
        }
        switch (address) {
            case 65532: {
                return 253;
            }
            case 65533: {
                return 79;
            }
        }
        return this.memory[address];
    }

    @Override
    public void setPrgBank(int bank, int value) {
        int address = bank << 12;
        int offset = value << 12;
        if (offset >= this.prgROM.length) {
            Arrays.fill(this.memory, address, address + 4096, 0);
        } else {
            System.arraycopy(this.prgROM, offset, this.memory, address, 4096);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address < 32768 || this.fdsAudio != null && address < 57344) {
            this.memory[address] = value;
        }
        if (address >= 24566 && address < 24576) {
            this.setPrgBank(address & 0xF, value);
        }
        for (int i = this.audios.length - 1; i >= 0 && !this.audios[i].writeRegister(address, value); --i) {
        }
    }

    @Override
    public void handleFrameRendered() {
        if (this.cpu.getPC() == 20477) {
            switch (this.state) {
                case 1: {
                    this.volume = 1.0f;
                    this.songCpuCycles = 0L;
                    this.fixedLengthTrack = false;
                    this.apu.setFadeVolume(1.0f);
                    this.apu.clearInactiveSeconds();
                    this.initSong(this.requestedSong);
                    this.jumpSubroutine(this.nsfFile.getInitAddress());
                    double cyclesPerMilli = this.tvSystem.getCyclesPerSecond() / 1000.0;
                    long fadeMillis = this.nsfFile.getFadeMillis()[this.requestedSong];
                    this.fadeCycles = fadeMillis >= 0L ? Math.max(1L, Math.round((double)fadeMillis * cyclesPerMilli)) : (long)(8.0 * this.tvSystem.getCyclesPerSecond());
                    long trackMillis = this.nsfFile.getTrackMillis()[this.requestedSong];
                    if (trackMillis >= 0L) {
                        this.fixedLengthTrack = true;
                        this.trackCycles = Math.max(1L, Math.round((double)trackMillis * cyclesPerMilli));
                    } else {
                        this.trackCycles = this.defaultTrackLength ? Math.max(1L, Math.round((double)(60 * this.trackLengthMinutes) * this.tvSystem.getCyclesPerSecond()) - this.fadeCycles) : Long.MAX_VALUE;
                    }
                    this.volume = 1.0f;
                    this.songCpuCycles = 0L;
                    this.deltaVolume = 1.0f / (float)this.fadeCycles;
                    this.apu.setFadeVolume(1.0f);
                    this.apu.clearInactiveSeconds();
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (this.songPaused) break;
                    this.jumpSubroutine(this.nsfFile.getPlayAddress());
                }
            }
        }
    }

    @Override
    public void restore(NsfFile nsfFile) {
        super.restore(nsfFile);
        this.nsfFile = nsfFile;
    }

    @Override
    public void update() {
        if (!this.songPaused) {
            for (int i = this.chipCount - 1; i >= 0; --i) {
                this.audios[i].update();
            }
            if (this.state == 2) {
                ++this.songCpuCycles;
                if (this.trackCycles == 0L) {
                    if (this.fadeCycles > 0L) {
                        --this.fadeCycles;
                        this.volume -= this.deltaVolume;
                        this.apu.setFadeVolume(this.volume);
                    } else {
                        this.volume = 0.0f;
                        this.apu.setFadeVolume(0.0f);
                    }
                } else {
                    --this.trackCycles;
                }
            }
        }
    }

    public boolean isAudioActive() {
        if (this.songPaused || !this.automaticallyAdvanceTrack) {
            return true;
        }
        if (this.state == 2) {
            if (this.trackCycles <= 0L && this.fadeCycles <= 0L) {
                return false;
            }
            if (this.fixedLengthTrack) {
                return true;
            }
            return this.apu.getInactiveSeconds() < this.silenceSeconds;
        }
        return true;
    }

    public long getSongCpuCycles() {
        return this.songCpuCycles;
    }

    @Override
    public int getAudioMixerScale() {
        return this.audioMixerScale;
    }

    @Override
    public float getAudioSample() {
        switch (this.chipCount) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return this.audios[0].getAudioSample();
            }
        }
        int sum = 0;
        for (int i = this.chipCount - 1; i >= 0; --i) {
            sum = (int)((float)sum + this.audios[i].getAudioSample());
        }
        return sum / this.chipCount;
    }
}

