/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ntdec;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper221
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int mode;
    private int prgReg;

    public Mapper221(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.setChrBank(0);
        this.updateBanks();
    }

    private void updateBanks() {
        int outerBank = (this.mode & 0xFC) >> 2;
        if (BitUtil.getBitBool(this.mode, 1)) {
            if (BitUtil.getBitBool(this.mode, 8)) {
                this.setPrgBank(2, outerBank | this.prgReg);
                this.setPrgBank(3, outerBank | 7);
            } else {
                this.setPrgBanks(2, 2, outerBank | this.prgReg & 6);
            }
        } else {
            this.setPrgBank(2, outerBank | this.prgReg);
            this.setPrgBank(3, outerBank | this.prgReg);
        }
        this.setNametableMirroring(this.mode & 1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xC000) {
            case 32768: {
                this.mode = address;
                break;
            }
            case 49152: {
                this.prgReg = address & 7;
            }
        }
        this.updateBanks();
    }
}

