/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ntdec;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class TF1201
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] chrRegs = new int[8];
    private int prgReg0;
    private int prgReg1;
    private boolean prgMode;
    private int irqCounter;
    private boolean irqEnabled;

    public TF1201(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.updatePrgBanks();
        this.updateChrBanks();
    }

    private void updatePrgBanks() {
        if (this.prgMode) {
            this.setPrgBank(4, -2);
            this.setPrgBank(6, this.prgReg0);
        } else {
            this.setPrgBank(4, this.prgReg0);
            this.setPrgBank(6, -2);
        }
        this.setPrgBank(5, this.prgReg1);
        this.setPrgBank(7, -1);
    }

    private void updateChrBanks() {
        for (int i = 0; i < 8; ++i) {
            this.setChrBank(i, this.chrRegs[i]);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        if ((address = address & 0xF003 | (address & 0xC) >> 2) >= 45056 && address <= 57347) {
            int register = ((address >> 11) - 6 | address & 1) & 7;
            int shift = (address & 2) << 1;
            this.chrRegs[register] = this.chrRegs[register] & 240 >> shift | (value & 0xF) << shift;
            this.updateChrBanks();
        } else {
            switch (address & 0xF003) {
                case 32768: {
                    this.prgReg0 = value;
                    this.updatePrgBanks();
                    break;
                }
                case 40960: {
                    this.prgReg1 = value;
                    this.updatePrgBanks();
                    break;
                }
                case 36864: {
                    this.setNametableMirroring(value & 1);
                    break;
                }
                case 36865: {
                    this.prgMode = (value & 3) != 0;
                    this.updatePrgBanks();
                    break;
                }
                case 61440: {
                    this.irqCounter = this.irqCounter & 0xF0 | value & 0xF;
                    break;
                }
                case 61442: {
                    this.irqCounter = this.irqCounter & 0xF | (value & 0xF) << 4;
                    break;
                }
                case 61441: 
                case 61443: {
                    this.irqEnabled = (value & 2) != 0;
                    this.cpu.setMapperIrq(false);
                    if (this.ppu.getScanline() >= 240) break;
                    this.irqCounter -= 8;
                }
            }
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        if (this.irqEnabled && rendering && scanlineCycle == 0 && ++this.irqCounter == 237) {
            this.cpu.setMapperIrq(true);
        }
    }
}

