/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.NesFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC235
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int register;

    public BMC235(NesFile nesFile) {
        super(nesFile, 4, 1);
    }

    @Override
    public void init() {
        this.register = 0;
        this.setChrBank(0);
        this.updateBanks();
    }

    private void updateBanks() {
        if (BitUtil.getBitBool(this.register, 10)) {
            this.setNametableMirroring(2);
        } else {
            this.setNametableMirroring(this.register >> 13 & 1);
        }
        if (BitUtil.getBitBool(this.register, 11)) {
            this.setPrgBank(2, (this.register & 0x300) >> 3 | (this.register & 0x1F) << 1 | this.register >> 12 & 1);
            this.setPrgBank(3, (this.register & 0x300) >> 3 | (this.register & 0x1F) << 1 | this.register >> 12 & 1);
        } else {
            int b = ((this.register & 0x300) >> 4 | this.register & 0x1F) << 1;
            this.setPrgBank(2, b);
            this.setPrgBank(3, b | 1);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.register = address;
        this.updateBanks();
    }
}

