/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Gyruss
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] regOrder = new int[]{4, 5, 6, 7, 0, 1, 2, 3};
    private final int[] regs = new int[8];

    public Gyruss(CartFile cartFile) {
        super(cartFile, 32, 1, 32768, 24576);
    }

    @Override
    public void init() {
        this.setChrBank(0);
        for (int i = 20; i <= 31; ++i) {
            this.setPrgBank(i, 32 + i);
        }
        this.updateBanks();
    }

    public void updateBanks() {
        for (int i = 7; i >= 0; --i) {
            this.setPrgBank(i + 12, this.regs[regOrder[i]]);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address < 40960) {
            this.setNametableMirroring(value & 1 ^ 1);
        } else if (address >= 45056 && address < 61440) {
            int regIndex = address - 45056 >> 11 | address >> 1 & 1;
            this.regs[regIndex] = (address & 1) != 0 ? this.regs[regIndex] & 0xF | value << 4 : this.regs[regIndex] & 0xF0 | value & 0xF;
            this.updateBanks();
        }
    }
}

