/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class HP898F
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[2];

    public HP898F(CartFile cartFile) {
        super(cartFile, 4, 1, 24576, 32768);
    }

    @Override
    public void init() {
        this.regs[1] = 0;
        this.regs[0] = 0;
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        int prgReg = this.regs[1] >> 3 & 7;
        int prgMask = this.regs[1] >> 4 & 4;
        this.setChrBank(this.regs[0] >> 4 & 7 & ~((this.regs[0] & 1) << 2 | this.regs[0] & 2));
        this.setPrgBank(2, prgReg & ~prgMask);
        this.setPrgBank(3, prgReg | prgMask);
        this.setNametableMirroring(BitUtil.getBit(this.regs[1], 7) ^ 1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if ((address & 0x6000) == 24576) {
            this.regs[(address & 4) >> 2] = value;
            this.updateState();
        }
    }
}

