/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper040
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean irqEnabled;
    private int irqCounter;

    public Mapper040(CartFile cartFile) {
        super(cartFile, 8, 1, 32768, 24576);
        this.setPrgBank(3, 6);
        this.setPrgBank(4, 4);
        this.setPrgBank(5, 5);
        this.setPrgBank(7, 7);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xE000) {
            case 32768: {
                this.disableIrq();
                break;
            }
            case 40960: {
                this.irqEnabled = true;
                break;
            }
            case 57344: {
                this.setPrgBank(6, value & 7);
            }
        }
    }

    private void disableIrq() {
        this.irqEnabled = false;
        this.cpu.setMapperIrq(false);
        this.irqCounter = 0;
    }

    @Override
    public void update() {
        if (this.irqEnabled && ++this.irqCounter == 4096) {
            this.cpu.setMapperIrq(true);
            this.irqEnabled = false;
            this.irqCounter = 0;
        }
    }
}

