/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.NesFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper042
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean irqEnabled;
    private int irqCounter;

    public Mapper042(NesFile nesFile) {
        super(nesFile, 8, 1, 32768, 24576);
        this.setPrgBank(4, -4);
        this.setPrgBank(5, -3);
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xE003) {
            case 32768: {
                this.setChrBank(value);
                break;
            }
            case 57344: {
                this.setPrgBank(3, value & 0xF);
                break;
            }
            case 57345: {
                this.setNametableMirroring(BitUtil.getBit(value, 3));
                break;
            }
            case 57346: {
                this.writeIrqControl(value);
            }
        }
    }

    private void writeIrqControl(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 1);
        if (!this.irqEnabled) {
            this.cpu.setMapperIrq(false);
            this.irqCounter = 0;
        }
    }

    @Override
    public void update() {
        if (this.irqEnabled && ++this.irqCounter == 24576) {
            this.cpu.setMapperIrq(true);
        }
    }
}

