/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper050
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean irqEnabled;
    private int irqCounter;

    public Mapper050(CartFile cartFile) {
        super(cartFile, 8, 0, 32768, 24576);
        this.setPrgBank(3, 15);
        this.setPrgBank(4, 8);
        this.setPrgBank(5, 9);
        this.setPrgBank(7, 11);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 16416 && address <= 24575) {
            if ((address & 0x4120) == 16416) {
                this.writePrgBank(value);
            } else {
                this.writeIrqEnable(value);
            }
        } else {
            this.memory[address] = value;
        }
    }

    private void writePrgBank(int value) {
        this.setPrgBank(6, value & 8 | (value & 1) << 2 | (value & 6) >> 1);
    }

    private void writeIrqEnable(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 0);
        if (!this.irqEnabled) {
            this.disableIrq();
        }
    }

    private void disableIrq() {
        this.irqEnabled = false;
        this.cpu.setMapperIrq(false);
        this.irqCounter = 0;
    }

    @Override
    public void update() {
        if (this.irqEnabled && ++this.irqCounter == 4096) {
            this.cpu.setMapperIrq(true);
            this.irqEnabled = false;
            this.irqCounter = 0;
        }
    }
}

