/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper117
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqCounter;
    private int irqReloadValue;
    private int irqResetDelay;
    private boolean irqEnabled;
    private boolean irqEnabledAlt;

    public Mapper117(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.setPrgBanks(4, 4, -4);
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        boolean a12;
        if (this.irqResetDelay > 0) {
            --this.irqResetDelay;
        }
        boolean bl = a12 = (address & 0x1000) != 0;
        if (a12 && this.irqResetDelay == 0 && this.irqEnabled && this.irqEnabledAlt && this.irqCounter > 0 && --this.irqCounter == 0) {
            this.cpu.setMapperIrq(true);
            this.irqEnabledAlt = false;
        }
        if (a12) {
            this.irqResetDelay = 8;
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address) {
            case 32768: {
                this.setPrgBank(4, value);
                break;
            }
            case 32769: {
                this.setPrgBank(5, value);
                break;
            }
            case 32770: {
                this.setPrgBank(6, value);
                break;
            }
            case 32771: {
                this.setPrgBank(7, value);
                break;
            }
            case 40960: 
            case 40961: 
            case 40962: 
            case 40963: 
            case 40964: 
            case 40965: 
            case 40966: 
            case 40967: {
                this.setChrBank(address & 7, value);
                break;
            }
            case 49153: {
                this.irqReloadValue = value;
                break;
            }
            case 49154: {
                this.cpu.setMapperIrq(false);
                break;
            }
            case 49155: {
                this.irqCounter = this.irqReloadValue;
                this.irqEnabledAlt = true;
                break;
            }
            case 53248: {
                this.setNametableMirroring(value & 1);
                break;
            }
            case 57344: {
                this.irqEnabled = BitUtil.getBitBool(value, 0);
                this.cpu.setMapperIrq(false);
            }
        }
    }
}

