/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper230
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean multiMode;

    public Mapper230(CartFile cartFile) {
        super(cartFile, 4, 0);
    }

    @Override
    public void init() {
        if (this.multiMode) {
            this.setPrgBank(2, 8);
            this.setPrgBank(3, 9);
            this.setNametableMirroring(1);
        } else {
            this.setPrgBank(2, 0);
            this.setPrgBank(3, 7);
            this.setNametableMirroring(0);
        }
    }

    @Override
    public void resetting() {
        this.multiMode ^= true;
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (this.multiMode) {
            this.writeMultiRegister(value);
        } else {
            this.writeContraRegister(value);
        }
    }

    private void writeMultiRegister(int value) {
        if (BitUtil.getBitBool(value, 5)) {
            int bank = (value & 0x1F) + 8;
            this.setPrgBank(2, bank);
            this.setPrgBank(3, bank);
        } else {
            int bank = (value & 0x1E) + 8;
            this.setPrgBank(2, bank);
            this.setPrgBank(3, bank + 1);
        }
        this.setNametableMirroring(BitUtil.getBit(value, 6) ^ 1);
    }

    private void writeContraRegister(int value) {
        this.setPrgBank(2, value & 7);
        this.setPrgBank(3, 7);
        this.setNametableMirroring(0);
    }
}

