/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import java.util.Arrays;
import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper273
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] prgRegs = new int[2];
    private final int[] chrRegs = new int[8];
    private int mirroring;
    private int prescalerMask;
    private int prescaler;
    private int irqCounter;
    private boolean irqEnabled;

    public Mapper273(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        Arrays.fill(this.prgRegs, 0);
        Arrays.fill(this.chrRegs, 0);
        this.irqCounter = 0;
        this.prescaler = 0;
        this.prescalerMask = 0;
        this.mirroring = 0;
        this.irqEnabled = false;
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        this.setPrgBank(4, this.prgRegs[0]);
        this.setPrgBank(5, this.prgRegs[1]);
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
        for (int i = 7; i >= 0; --i) {
            this.setChrBank(i, this.chrRegs[i]);
        }
        this.setNametableMirroring(this.mirroring);
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            ++this.prescaler;
            this.prescaler &= 0xFF;
            if ((this.prescaler & this.prescalerMask) == 0) {
                this.prescalerMask = 255;
                ++this.irqCounter;
                this.irqCounter &= 0xFF;
                this.cpu.setMapperIrq(this.irqCounter == 0);
            }
        }
    }

    private void writeIRQ(int address, int value) {
        switch (address & 8) {
            case 0: {
                this.irqCounter = value;
                this.cpu.setMapperIrq(false);
                break;
            }
            case 8: {
                if ((value & 1) == 0) {
                    this.irqEnabled = false;
                    this.prescaler = 0;
                    this.prescalerMask = 127;
                    this.cpu.setMapperIrq(false);
                    break;
                }
                this.irqEnabled = true;
            }
        }
    }

    private void writeMirroring(int value) {
        this.mirroring = value & 1;
        this.updateState();
    }

    private void writePrgRegs(int address, int value) {
        this.prgRegs[BitUtil.getBit((int)address, (int)13)] = value;
        this.updateState();
    }

    private void writeChrRegs(int address, int value) {
        int reg = (address >> 12) - 11 << 1 | (address & 8) >> 3;
        this.chrRegs[reg] = BitUtil.getBitBool(address, 2) ? value << 4 | this.chrRegs[reg] & 0xF : this.chrRegs[reg] & 0xF0 | value & 0xF;
        this.updateState();
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (0xF000 & address) {
            case 32768: 
            case 40960: {
                this.writePrgRegs(address, value);
                break;
            }
            case 36864: {
                this.writeMirroring(value);
                break;
            }
            case 45056: 
            case 49152: 
            case 53248: 
            case 57344: {
                this.writeChrRegs(address, value);
                break;
            }
            case 61440: {
                this.writeIRQ(address, value);
            }
        }
    }
}

