/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper326
extends Mapper {
    private static final long serialVersionUID = 0L;

    public Mapper326(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.set4PrgBanks(4, -4);
        this.set8ChrBanks(0, 0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xE010) {
            case 32768: {
                this.setPrgBank(4, value);
                break;
            }
            case 40960: {
                this.setPrgBank(5, value);
                break;
            }
            case 49152: {
                this.setPrgBank(6, value);
            }
        }
        switch (address & 0x8018) {
            case 32784: {
                this.setChrBank(address & 7, value);
                break;
            }
            case 32792: {
                this.setNametable(address & 3, value & 1);
            }
        }
    }
}

