/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class ShuiGuanPipe
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqCounter;
    private int irqPre;
    private boolean irqEnabled;

    public ShuiGuanPipe(CartFile cartFile) {
        super(cartFile, 8, 8, 24576, 24576);
    }

    @Override
    public void init() {
        this.irqPre = 0;
        this.irqCounter = 0;
        this.irqEnabled = false;
        for (int i = 7; i >= 0; --i) {
            this.setPrgBank(i, 0);
            this.setChrBank(i, 0);
        }
        this.setPrgBank(7, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if ((address & 0xF800) == 26624) {
            this.setPrgBank(3, address & 0x3F);
        } else if ((address & 0xF80C) >= 45056 && (address & 0xF80C) <= 57356) {
            int index = ((address >> 11) - 6 | address >> 3) & 7;
            this.chrBanks[index] = (this.chrBanks[index] >> 10 & 240 >> (address & 4) | (value & 0xF) << (address & 4)) << 10;
        } else {
            switch (address & 0xF80C) {
                case 34816: {
                    this.setPrgBank(4, value);
                    break;
                }
                case 38912: {
                    this.setNametableMirroring(value & 3);
                    break;
                }
                case 43008: {
                    this.setPrgBank(5, value);
                    break;
                }
                case 40960: {
                    this.setPrgBank(6, value);
                    break;
                }
                case 61440: {
                    this.irqCounter = this.irqCounter & 0xF0 | value & 0xF;
                    break;
                }
                case 61444: {
                    this.irqCounter = this.irqCounter & 0xF | (value & 0xF) << 4;
                    break;
                }
                case 61448: {
                    boolean bl = this.irqEnabled = value != 0;
                    if (!this.irqEnabled) {
                        this.irqPre = 0;
                    }
                    this.cpu.setMapperIrq(false);
                    break;
                }
                case 61452: {
                    this.irqPre = 16;
                }
            }
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        if (rendering && this.irqEnabled && scanlineCycle == 256) {
            this.irqCounter = this.irqCounter + 1 & 0xFF;
            if (this.irqCounter - this.irqPre == 238) {
                this.cpu.setMapperIrq(true);
            }
        }
    }
}

