/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.NesFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Supervision
extends Mapper {
    private final int[] regs = new int[2];

    public Supervision(NesFile nesFile) {
        super(nesFile, 8, 1, 24576, 24576);
    }

    private void updateBanks() {
        int r = this.regs[0] << 3 & 0x78;
        this.setPrgBank(3, (r << 1 | 0xF) + 4);
        this.setPrgBanks(4, 2, ((this.regs[0] & 0x10) != 0 ? (r | this.regs[1] & 7) + 2 : 0) << 1);
        this.setPrgBanks(6, 2, ((this.regs[0] & 0x10) != 0 ? (r | 7) + 2 : 1) << 1);
        this.setNametableMirroring(BitUtil.getBit(this.regs[0], 5));
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.regs[BitUtil.getBit((int)address, (int)15)] = value;
        this.updateBanks();
    }
}

