/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class BMCF15
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int reg;

    public BMCF15(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.reg = 0;
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public void updatePrgBanks() {
        int bank = this.reg & 0xF;
        int mode = (this.reg & 8) >> 3;
        int mask = ~mode;
        this.set2PrgBanks(4, (bank & mask) << 1);
        this.set2PrgBanks(6, (bank & mask | mode) << 1);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            if (this.prgRamChipEnabled) {
                this.reg = value;
                this.updatePrgBanks();
            }
        } else {
            super.writeMemory(address, value);
        }
    }
}

