/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper116
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] MIRRORING = new int[]{2, 3, 0, 1};
    private static final int MapperModeVRC2b = 0;
    private static final int MapperModeMMC3 = 1;
    private final int[] vrc2Chr = new int[]{-1, -1, -1, -1, 4, 5, 6, 7};
    private final int[] vrc2Prg = new int[]{0, 1};
    private final int[] mmc3Regs = new int[]{0, 2, 4, 5, 6, 7, -4, -3, -2, -1};
    private final int[] mmc1Regs = new int[]{12, 0, 0, 0};
    private int mode;
    private int vrc2Mirror;
    private int mmc3Control;
    private int mmc3Mirror;
    private int mmc1Buffer;
    private int mmc1Shift;
    private int irqCounter;
    private int irqReloadValue;
    private int irqResetDelay;
    private boolean irqEnabled;
    private boolean irqReloadRequest;

    public Mapper116(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.updateBanks();
    }

    private void updatePrgBanks() {
        switch (this.mode & 3) {
            case 0: {
                this.setPrgBank(4, this.vrc2Prg[0]);
                this.setPrgBank(5, this.vrc2Prg[1]);
                this.setPrgBank(6, -2);
                this.setPrgBank(7, -1);
                break;
            }
            case 1: {
                int swap = this.mmc3Control >> 5 & 2;
                this.setPrgBank(4, this.mmc3Regs[6 + swap]);
                this.setPrgBank(5, this.mmc3Regs[7]);
                this.setPrgBank(6, this.mmc3Regs[6 + (swap ^ 2)]);
                this.setPrgBank(7, this.mmc3Regs[9]);
                break;
            }
            default: {
                int bank = this.mmc1Regs[3] & 0xF;
                if (BitUtil.getBitBool(this.mmc1Regs[0], 3)) {
                    int b = bank << 1;
                    if (BitUtil.getBitBool(this.mmc1Regs[0], 2)) {
                        this.setPrgBank(4, b);
                        this.setPrgBank(5, b | 1);
                        this.setPrgBank(6, 30);
                        this.setPrgBank(7, 31);
                        break;
                    }
                    this.setPrgBank(4, 0);
                    this.setPrgBank(5, 1);
                    this.setPrgBank(6, b);
                    this.setPrgBank(7, b | 1);
                    break;
                }
                int b = bank >> 1 << 2;
                this.setPrgBank(4, b);
                this.setPrgBank(5, b | 1);
                this.setPrgBank(6, b | 2);
                this.setPrgBank(7, b | 3);
                break;
            }
        }
    }

    private void updateChrBanks() {
        int base = (this.mode & 4) << 6;
        switch (this.mode & 3) {
            case 0: {
                this.setChrBank(0, base | this.vrc2Chr[0]);
                this.setChrBank(1, base | this.vrc2Chr[1]);
                this.setChrBank(2, base | this.vrc2Chr[2]);
                this.setChrBank(3, base | this.vrc2Chr[3]);
                this.setChrBank(4, base | this.vrc2Chr[4]);
                this.setChrBank(5, base | this.vrc2Chr[5]);
                this.setChrBank(6, base | this.vrc2Chr[6]);
                this.setChrBank(7, base | this.vrc2Chr[7]);
                break;
            }
            case 1: {
                if (BitUtil.getBitBool(this.mmc3Control, 7)) {
                    this.setChrBank(0, base | this.mmc3Regs[2]);
                    this.setChrBank(1, base | this.mmc3Regs[3]);
                    this.setChrBank(2, base | this.mmc3Regs[4]);
                    this.setChrBank(3, base | this.mmc3Regs[5]);
                    this.setChrBank(4, base | this.mmc3Regs[0] & 0xFE);
                    this.setChrBank(5, base | this.mmc3Regs[0] | 1);
                    this.setChrBank(6, base | this.mmc3Regs[1] & 0xFE);
                    this.setChrBank(7, base | this.mmc3Regs[1] | 1);
                    break;
                }
                this.setChrBank(0, base | this.mmc3Regs[0] & 0xFE);
                this.setChrBank(1, base | this.mmc3Regs[0] | 1);
                this.setChrBank(2, base | this.mmc3Regs[1] & 0xFE);
                this.setChrBank(3, base | this.mmc3Regs[1] | 1);
                this.setChrBank(4, base | this.mmc3Regs[2]);
                this.setChrBank(5, base | this.mmc3Regs[3]);
                this.setChrBank(6, base | this.mmc3Regs[4]);
                this.setChrBank(7, base | this.mmc3Regs[5]);
                break;
            }
            default: {
                if (BitUtil.getBitBool(this.mmc1Regs[0], 4)) {
                    int b1 = this.mmc1Regs[1] << 2;
                    this.setChrBank(0, b1);
                    this.setChrBank(1, b1 | 1);
                    this.setChrBank(2, b1 | 2);
                    this.setChrBank(3, b1 | 3);
                    int b2 = this.mmc1Regs[2] << 2;
                    this.setChrBank(4, b2);
                    this.setChrBank(5, b2 | 1);
                    this.setChrBank(6, b2 | 2);
                    this.setChrBank(7, b2 | 3);
                    break;
                }
                int b = this.mmc1Regs[1] >> 1 << 3;
                this.setChrBank(0, b);
                this.setChrBank(1, b | 1);
                this.setChrBank(2, b | 2);
                this.setChrBank(3, b | 3);
                this.setChrBank(4, b | 4);
                this.setChrBank(5, b | 5);
                this.setChrBank(6, b | 6);
                this.setChrBank(7, b | 7);
            }
        }
    }

    private void updateNametableMirroring() {
        switch (this.mode & 3) {
            case 0: {
                this.setNametableMirroring(this.vrc2Mirror & 1);
                break;
            }
            case 1: {
                this.setNametableMirroring(this.mmc3Mirror & 1);
                break;
            }
            default: {
                this.setNametableMirroring(MIRRORING[this.mmc1Regs[0] & 3]);
            }
        }
    }

    private void updateBanks() {
        this.updatePrgBanks();
        this.updateChrBanks();
        this.updateNametableMirroring();
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 16640 && address <= Short.MAX_VALUE && (address & 0x4100) == 16640) {
            this.mode = value;
            if (BitUtil.getBitBool(address, 0)) {
                this.mmc1Regs[0] = 12;
                this.mmc1Regs[3] = 0;
                this.mmc1Buffer = 0;
                this.mmc1Shift = 0;
            }
            this.updateBanks();
        }
        super.writeMemory(address, value);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (this.mode & 3) {
            case 0: {
                if (address >= 45056 && address <= 57347) {
                    int index = ((address & 2 | address >> 10) >> 1) + 2 & 7;
                    int shift = (address & 1) << 2;
                    this.vrc2Chr[index] = this.vrc2Chr[index] & 240 >> shift | (value & 0xF) << shift;
                    this.updateChrBanks();
                    break;
                }
                switch (address & 0xF000) {
                    case 32768: {
                        this.vrc2Prg[0] = value;
                        this.updatePrgBanks();
                        break;
                    }
                    case 40960: {
                        this.vrc2Prg[1] = value;
                        this.updatePrgBanks();
                        break;
                    }
                    case 36864: {
                        this.vrc2Mirror = value;
                        this.updateNametableMirroring();
                    }
                }
                break;
            }
            case 1: {
                switch (address & 0xE001) {
                    case 32768: {
                        int old_ctrl = this.mmc3Control;
                        this.mmc3Control = value;
                        if ((old_ctrl & 0x40) != (this.mmc3Control & 0x40)) {
                            this.updatePrgBanks();
                        }
                        if ((old_ctrl & 0x80) == (this.mmc3Control & 0x80)) break;
                        this.updateChrBanks();
                        break;
                    }
                    case 32769: {
                        this.mmc3Regs[this.mmc3Control & 7] = value;
                        if ((this.mmc3Control & 7) < 6) {
                            this.updateChrBanks();
                            break;
                        }
                        this.updatePrgBanks();
                        break;
                    }
                    case 40960: {
                        this.mmc3Mirror = value;
                        this.updateNametableMirroring();
                        break;
                    }
                    case 49152: {
                        this.irqReloadValue = value;
                        break;
                    }
                    case 49153: {
                        this.irqReloadRequest = true;
                        break;
                    }
                    case 57344: {
                        this.cpu.setMapperIrq(false);
                        this.irqEnabled = false;
                        break;
                    }
                    case 57345: {
                        this.irqEnabled = true;
                    }
                }
                break;
            }
            default: {
                if (BitUtil.getBitBool(value, 7)) {
                    this.mmc1Regs[0] = this.mmc1Regs[0] | 0xC;
                    this.mmc1Shift = 0;
                    this.mmc1Buffer = 0;
                    this.updatePrgBanks();
                    break;
                }
                int n = (address >> 13) - 4;
                this.mmc1Buffer |= (value & 1) << this.mmc1Shift++;
                if (this.mmc1Shift != 5) break;
                this.mmc1Regs[n] = this.mmc1Buffer;
                this.mmc1Shift = 0;
                this.mmc1Buffer = 0;
                switch (n) {
                    case 0: {
                        this.updateNametableMirroring();
                    }
                    case 2: {
                        this.updateChrBanks();
                    }
                    case 1: 
                    case 3: {
                        this.updatePrgBanks();
                    }
                }
            }
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        if ((this.mode & 3) == 1) {
            boolean a12;
            if (this.irqResetDelay > 0) {
                --this.irqResetDelay;
            }
            boolean bl = a12 = (address & 0x1000) != 0;
            if (a12 && this.irqResetDelay == 0) {
                this.irqCounter = this.irqCounter > 0 ? --this.irqCounter : this.irqReloadValue;
                if (this.irqReloadRequest) {
                    this.irqReloadRequest = false;
                    this.irqCounter = this.irqReloadValue;
                }
                if (this.irqCounter == 0 && this.irqEnabled) {
                    this.cpu.setMapperIrq(true);
                }
            }
            if (a12) {
                this.irqResetDelay = 8;
            }
        }
    }
}

