/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper121
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] LUT = new int[]{131, 131, 66, 0};
    private final int[] regs = new int[8];

    public Mapper121(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.regs[2] = 0;
        this.regs[1] = 0;
        this.regs[0] = 0;
        this.regs[3] = 128;
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF000) == 20480) {
            return this.regs[4];
        }
        return super.readMemory(address);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        int v = (this.regs[3] & 0x80) >> 2;
        if ((this.regs[5] & 0x3F) != 0) {
            super.setPrgBank(bank, value & 0x1F | v);
            super.setPrgBank(5, this.regs[2] | v);
            super.setPrgBank(6, this.regs[1] | v);
            super.setPrgBank(7, this.regs[0] | v);
        } else {
            super.setPrgBank(bank, value & 0x1F | v);
        }
    }

    @Override
    protected void setChrBank(int bank, int value) {
        if (this.prgRomLength == this.chrRomLength) {
            super.setChrBank(bank, value | (this.regs[3] & 0x80) << 1);
        } else {
            if (bank >= 4 == this.chrMode) {
                value |= 0x100;
            }
            super.setChrBank(bank, value);
        }
    }

    private void updateRegisters() {
        switch (this.regs[5] & 0x3F) {
            case 32: {
                this.regs[7] = 1;
                this.regs[0] = this.regs[6];
                break;
            }
            case 41: {
                this.regs[7] = 1;
                this.regs[0] = this.regs[6];
                break;
            }
            case 38: {
                this.regs[7] = 0;
                this.regs[0] = this.regs[6];
                break;
            }
            case 43: {
                this.regs[7] = 1;
                this.regs[0] = this.regs[6];
                break;
            }
            case 44: {
                this.regs[7] = 1;
                if (this.regs[6] == 0) break;
                this.regs[0] = this.regs[6];
                break;
            }
            case 60: 
            case 63: {
                this.regs[7] = 1;
                this.regs[0] = this.regs[6];
                break;
            }
            case 40: {
                this.regs[7] = 0;
                this.regs[1] = this.regs[6];
                break;
            }
            case 42: {
                this.regs[7] = 0;
                this.regs[2] = this.regs[6];
                break;
            }
            case 47: {
                break;
            }
            default: {
                this.regs[5] = 0;
            }
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        switch (address & 0xF000) {
            case 20480: {
                this.regs[4] = LUT[value & 3];
                if ((address & 0x5180) != 20864) break;
                this.regs[3] = value;
                this.updateBanks();
                break;
            }
            case 32768: 
            case 36864: {
                if ((address & 3) == 3) {
                    this.regs[5] = value;
                    this.updateRegisters();
                    this.writeBankSelect(value);
                    break;
                }
                if (BitUtil.getBitBool(address, 0)) {
                    this.regs[6] = (value & 1) << 5 | (value & 2) << 3 | (value & 4) << 1 | (value & 8) >> 1 | (value & 0x10) >> 3 | (value & 0x20) >> 5;
                    if (this.regs[7] == 0) {
                        this.updateRegisters();
                    }
                    this.writeBankData(value);
                    break;
                }
                this.writeBankSelect(value);
                break;
            }
            default: {
                if (address < this.minRegisterAddress) break;
                this.writeRegister(address, value);
            }
        }
    }
}

