/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper123
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] security = new int[]{0, 3, 1, 5, 6, 7, 2, 4};
    private final int[] regs = new int[2];

    public Mapper123(CartFile cartFile) {
        super(cartFile);
        this.memory[24437] = 255;
        this.memory[24436] = 255;
    }

    @Override
    public void updatePrgBanks() {
        if (BitUtil.getBitBool(this.regs[0], 6)) {
            int bank = this.regs[0] & 5 | (this.regs[0] & 8) >> 2 | (this.regs[0] & 0x20) >> 2;
            if (BitUtil.getBitBool(this.regs[0], 1)) {
                this.setPrgBanks(4, 4, (bank & 0xFE) << 1);
            } else {
                this.setPrgBanks(4, 2, bank << 1);
                this.setPrgBanks(6, 2, bank << 1);
            }
        } else {
            super.updatePrgBanks();
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address >= 32768 || address >= 20481 && address < 24576) {
            this.writeRegister(address, value);
        }
    }

    @Override
    public void writeRegister(int address, int value) {
        if (address < 32768 && BitUtil.getBitBool(address, 11)) {
            this.regs[address & 1] = value;
            this.updatePrgBanks();
        } else if (address < 40960) {
            switch (address & 0x8001) {
                case 32768: {
                    this.writeBankSelect(value & 0xC0 | security[value & 7]);
                    break;
                }
                case 32769: {
                    this.writeBankData(value);
                }
            }
        } else {
            super.writeRegister(address, value);
        }
    }
}

