/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper165
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final boolean[] latches = new boolean[2];

    public Mapper165(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public int readVRAM(int address) {
        int bankAddress;
        int value = address < 8192 ? ((bankAddress = (this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask) < 4096 ? this.vram[bankAddress] : this.chrROM[bankAddress]) : this.vram[address];
        switch (address & 0xFFF8) {
            case 4056: 
            case 8152: {
                Mapper165.latches[1] = false;
                Mapper165.latches[0] = false;
                this.updateChrBanks();
                break;
            }
            case 4072: {
                Mapper165.latches[0] = true;
                this.updateChrBanks();
                break;
            }
            case 8168: {
                Mapper165.latches[1] = true;
                this.updateChrBanks();
            }
        }
        return value;
    }

    @Override
    protected void updateChrBanks() {
        this.setBanks(this.chrBanks, 0, (latches[0] ? this.R[1] : this.R[0]) << 10, 4, 1024);
        this.setBanks(this.chrBanks, 4, (latches[1] ? this.R[4] : this.R[2]) << 10, 4, 1024);
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192) {
            int bankAddress = (this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask;
            if (bankAddress < 4096) {
                this.vram[bankAddress] = value;
            }
        } else {
            this.vram[address] = value;
        }
    }
}

