/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.NesFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper182
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] REGISTERS = new int[]{0, 3, 1, 5, 6, 7, 2, 4};

    public Mapper182(NesFile nesFile) {
        super(nesFile);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address < 32768) {
            this.memory[address] = value;
        } else {
            switch (address & 0xE001) {
                case 32769: {
                    this.writeMirroring(value);
                    break;
                }
                case 40960: {
                    this.writeBankSelect(value);
                    break;
                }
                case 49152: {
                    this.writeBankData(value);
                    break;
                }
                case 49153: {
                    this.writeIrqLatch(value);
                    this.writeIrqReload();
                    break;
                }
                case 57344: {
                    this.writeIrqDisable();
                    break;
                }
                case 57345: {
                    this.writeIrqEnable();
                }
            }
        }
    }

    @Override
    protected void writeBankSelect(int value) {
        this.chrMode = BitUtil.getBitBool(value, 7);
        this.prgMode = BitUtil.getBitBool(value, 6);
        this.register = REGISTERS[value & 7];
        this.updateBanks();
    }
}

