/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper196
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private boolean bankMode;
    private int bank;

    public Mapper196(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    protected void updatePrgBanks() {
        if (this.bankMode) {
            this.setPrgBanks(4, 4, this.bank);
        } else {
            super.updatePrgBanks();
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address >= 24576) {
            if (address < 32768) {
                this.bankMode = true;
                this.bank = (value & 0xF | value >> 4) << 2;
                this.updatePrgBanks();
            } else {
                address = address >= 49152 ? address & 0xFFFE | address >> 2 & 1 | address >> 3 & 1 : address & 0xFFFE | address >> 2 & 1 | address >> 3 & 1 | address >> 1 & 1;
                super.writeRegister(address, value);
            }
        }
    }
}

