/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper219
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[3];

    public Mapper219(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.setPrgBanks(4, 4, -4);
        this.setChrBanks(0, 8, 0);
    }

    @Override
    protected void updatePrgBanks() {
    }

    @Override
    protected void updateChrBanks() {
    }

    @Override
    public void writeRegister(int address, int value) {
        if (address < 40960) {
            block0 : switch (address & 0xE003) {
                case 32768: {
                    this.regs[0] = 0;
                    this.regs[1] = value;
                    break;
                }
                case 32769: {
                    if (this.regs[0] >= 35 && this.regs[0] <= 38) {
                        this.setPrgBank(42 - this.regs[0], (value & 0x20) >> 5 | (value & 0x10) >> 3 | (value & 8) >> 1 | (value & 4) << 1);
                    }
                    switch (this.regs[1]) {
                        case 8: 
                        case 10: 
                        case 14: 
                        case 18: 
                        case 22: 
                        case 26: 
                        case 30: {
                            this.regs[2] = value << 4;
                            break block0;
                        }
                        case 9: {
                            this.setChrBank(0, this.regs[2] | value >> 1 & 0xE);
                            break block0;
                        }
                        case 11: {
                            this.setChrBank(1, this.regs[2] | (value >> 1 | 1));
                            break block0;
                        }
                        case 12: 
                        case 13: {
                            this.setChrBank(2, this.regs[2] | value >> 1 & 0xE);
                            break block0;
                        }
                        case 15: {
                            this.setChrBank(3, this.regs[2] | (value >> 1 | 1));
                            break block0;
                        }
                        case 16: 
                        case 17: {
                            this.setChrBank(4, this.regs[2] | value >> 1 & 0xF);
                            break block0;
                        }
                        case 20: 
                        case 21: {
                            this.setChrBank(5, this.regs[2] | value >> 1 & 0xF);
                            break block0;
                        }
                        case 24: 
                        case 25: {
                            this.setChrBank(6, this.regs[2] | value >> 1 & 0xF);
                            break block0;
                        }
                        case 28: 
                        case 29: {
                            this.setChrBank(7, this.regs[2] | value >> 1 & 0xF);
                        }
                    }
                    break;
                }
                case 32770: {
                    this.regs[0] = value;
                    this.regs[1] = 0;
                }
            }
        } else {
            super.writeRegister(address, value);
        }
    }
}

