/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper269
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] UNSCRAMBLE = new int[256];
    private final int[] reg = new int[4];
    private int chrMask;
    private int regIndex;

    public Mapper269(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.regIndex = 0;
        this.reg[3] = 0;
        this.reg[1] = 0;
        this.reg[0] = 0;
        this.reg[2] = 15;
        this.chrMask = 255;
        this.updateState();
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private int getChrBank(int bank) {
        if (this.chrMode) {
            switch (bank) {
                case 0: {
                    return this.R[2];
                }
                case 1: {
                    return this.R[3];
                }
                case 2: {
                    return this.R[4];
                }
                case 3: {
                    return this.R[5];
                }
                case 4: {
                    return this.R[0] & 0xFE;
                }
                case 5: {
                    return this.R[0] | 1;
                }
                case 6: {
                    return this.R[1] & 0xFE;
                }
            }
            return this.R[1] | 1;
        }
        switch (bank) {
            case 0: {
                return this.R[0] & 0xFE;
            }
            case 1: {
                return this.R[0] | 1;
            }
            case 2: {
                return this.R[1] & 0xFE;
            }
            case 3: {
                return this.R[1] | 1;
            }
            case 4: {
                return this.R[2];
            }
            case 5: {
                return this.R[3];
            }
            case 6: {
                return this.R[4];
            }
        }
        return this.R[5];
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return UNSCRAMBLE[this.prgROM[((this.getChrBank(address >> 10) & this.chrMask) + (this.reg[0] & ~this.chrMask | (this.reg[2] & 0xF0) << 4 | (this.reg[3] & 0xC0) << 6) << 10 | address & 0x3FF) & this.prgRomSizeMask]];
        }
        return super.readVRAM(address);
    }

    private void updateState() {
        int prgMask = ~this.reg[3] & 0x3F;
        this.setPrgBlock(this.reg[1] & ~prgMask | (this.reg[3] & 0xC0) << 2, prgMask);
    }

    private void writeOuterBankRegisters(int value) {
        if (this.regIndex == 2) {
            this.chrMask = (value & 8) != 0 ? 255 >> (~value & 7) : 255;
        }
        this.reg[this.regIndex++] = value;
        this.regIndex &= 3;
        this.updateState();
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address == 20480) {
            this.writeOuterBankRegisters(value);
        }
        super.writeMemory(address, value);
    }

    static {
        for (int i = UNSCRAMBLE.length - 1; i >= 0; --i) {
            Mapper269.UNSCRAMBLE[i] = (i & 1) << 6 | (i & 2) << 3 | i & 4 | (i & 8) >> 3 | (i & 0x10) >> 3 | (i & 0x20) >> 2 | (i & 0x40) >> 1 | i & 0x80;
        }
    }
}

