/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sachen;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper512
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] CIRAM = new int[4096];
    private int mode;

    public Mapper512(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (this.mode == 1 && address >= 8192 && address < 16128) {
            this.CIRAM[address & 0xFFF] = value;
        } else {
            super.writeVRAM(address, value);
        }
    }

    @Override
    public int readVRAM(int address) {
        if (this.mode == 1 && address >= 8192 && address < 16128) {
            return this.CIRAM[address & 0xFFF];
        }
        return super.readVRAM(address);
    }

    private void writeMode(int value) {
        System.out.println(value);
        this.mode = value & 3;
        this.chrRamPresent = this.mode != 0;
        this.updateChrBanks();
    }

    @Override
    protected void updateChrBanks() {
        if (this.mode >= 2) {
            this.set4ChrBanks(0, 0);
            this.set4ChrBanks(4, 0);
        } else {
            super.updateChrBanks();
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address == 16640) {
            this.writeMode(value);
        }
        super.writeMemory(address, value);
    }
}

