/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sachen;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Sachen74LS374N
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[8];
    private int register;

    public Sachen74LS374N(CartFile cartFile) {
        super(cartFile, 2, 1);
    }

    @Override
    public void init() {
        this.setPrgBank(0);
    }

    private void updateBanks() {
        this.setChrBank((this.regs[2] & 1) << 3 | (this.regs[6] & 3) << 1 | this.regs[4] & 1);
        this.setPrgBank(this.regs[5] & 1);
        this.setNametableMirroring(this.regs[7] & 1 ^ 1);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        switch (address & 0xC101) {
            case 16640: {
                this.register = value & 7;
                break;
            }
            case 16641: {
                this.regs[this.register] = value;
                if (this.register == 0) {
                    this.setChrBank(3);
                    this.setPrgBank(0);
                    break;
                }
                this.updateBanks();
            }
        }
    }
}

