/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sachen;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Sachen74LS374Nb
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] NAMETABLE_MIRRORINGS = new int[]{1, 0, 6, 2};
    private final int[] regs = new int[8];
    private int resetBit;
    private int register;

    public Sachen74LS374Nb(CartFile cartFile) {
        super(cartFile, 2, 1);
    }

    @Override
    public void init() {
        this.setPrgBank(0);
    }

    @Override
    public void resetting() {
        this.resetBit ^= 1;
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xC101) == 16384) {
            return ~this.register ^ this.resetBit;
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        switch (address & 0xC101) {
            case 16640: {
                this.register = value & 7;
                break;
            }
            case 16641: {
                this.regs[this.register] = value;
                this.updateBanks();
            }
        }
    }

    private void updateBanks() {
        this.setChrBank((this.regs[2] & 1) << 3 | (this.regs[4] & 1) << 2 | this.regs[6] & 3);
        if (this.register == 2) {
            this.setPrgBank(this.regs[2] & 1);
        } else {
            this.setPrgBank(this.regs[5] & 7);
        }
        this.setNametableMirroring(NAMETABLE_MIRRORINGS[this.regs[7] >> 1 & 3]);
    }
}

