/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sachen;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;

public abstract class Sachen8259
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected static final int[] NAMETABLE_MIRRORING = new int[]{0, 1, 6, 2};
    protected final int[] chrRegs = new int[4];
    protected int register;
    protected boolean simpleMode;

    public Sachen8259(CartFile cartFile) {
        super(cartFile, 2, 4);
    }

    public Sachen8259(CartFile cartFile, int prgBanksSize, int chrBanksSize) {
        super(cartFile, prgBanksSize, chrBanksSize);
    }

    @Override
    public void init() {
        this.preferredTVSystem = TVSystem.NTSC;
    }

    @Override
    public void writeMemory(int address, int value) {
        switch (address & 0xC101) {
            case 16640: {
                this.writeRegisterSelect(value);
                break;
            }
            case 16641: {
                this.writeRegisterData(value);
                break;
            }
            default: {
                this.memory[address] = value;
            }
        }
    }

    protected void writeRegisterSelect(int value) {
        this.register = value & 7;
    }

    protected abstract void writeRegisterData(int var1);

    protected void writeModeAndMirroringSelect(int value) {
        if (this.nametableMirroring != 4) {
            this.simpleMode = BitUtil.getBitBool(value, 0);
            if (this.simpleMode) {
                this.setNametableMirroring(0);
            } else {
                this.setNametableMirroring(NAMETABLE_MIRRORING[value >> 1]);
            }
        }
    }

    protected void writeChrSelect(int bank, int value) {
        this.chrRegs[bank] = this.chrRegs[bank] & 0xF8 | value;
        this.updateChrBanks();
    }

    protected abstract void updateChrBanks();
}

